% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variableKey.R
\name{keyCheck}
\alias{keyCheck}
\title{Check a key for consistency of names, values with classes.}
\usage{
keyCheck(key, colname = c("name_new", "class_old", "class_new"),
  na.strings = c("\\\\.", "", "\\\\s+", "N/A"))
}
\arguments{
\item{key}{A variable key object.}

\item{colname}{Leave as default to check consistency between classes, values, and names.
One can specify a check only on "class_old" or "class_new", for example.  But now that
all work correctly, I suggest you leave the default.}

\item{na.strings}{A regular expression of allowed text strings that represent missings.
Now it amounts to any of these: ".", "NA", "N/A", or any white space or tab as signified by \\s+.}
}
\value{
Profuse warnings and a list of failed key blocks.
}
\description{
Split the key into blocks of rows defined by "name_new". Within
these blocks, Perform these checks: 1. name_old must be
homogeneous (identical) within a block of rows. class_old and
class_new must also be identical.
2. elements in "value_new" must be consistent with "class_new".
If values cannot be coerced to match the class specified by
class_new, there must be user error.
Same for "value_old" and "class_old".
}
\author{
Paul Johnson <pauljohn@ku.edu> and Ben Kite <bakite@ku.edu>
}
