% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cyclocomp_linter.R
\name{cyclocomp_linter}
\alias{cyclocomp_linter}
\title{Cyclomatic complexity linter}
\usage{
cyclocomp_linter(complexity_limit = 15L)
}
\arguments{
\item{complexity_limit}{Maximum cyclomatic complexity, default 15. Expressions more complex
than this are linted. See \code{\link[cyclocomp:cyclocomp]{cyclocomp::cyclocomp()}}.}
}
\description{
Check for overly complicated expressions. See \code{\link[cyclocomp:cyclocomp]{cyclocomp::cyclocomp()}}.
}
\examples{
# will produce lints
lint(
  text = "if (TRUE) 1 else 2",
  linters = cyclocomp_linter(complexity_limit = 1L)
)

# okay
lint(
  text = "if (TRUE) 1 else 2",
  linters = cyclocomp_linter(complexity_limit = 2L)
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=configurable_linters]{configurable}, \link[=default_linters]{default}, \link[=readability_linters]{readability}, \link[=style_linters]{style}
}
