% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inner_combine_linter.R
\name{inner_combine_linter}
\alias{inner_combine_linter}
\title{Require \code{c()} to be applied before relatively expensive vectorized functions}
\usage{
inner_combine_linter()
}
\description{
\code{as.Date(c(a, b))} is logically equivalent to \code{c(as.Date(a), as.Date(b))}.
The same equivalence holds for several other vectorized functions like
\code{\link[=as.POSIXct]{as.POSIXct()}} and math functions like \code{\link[=sin]{sin()}}. The former is to be
preferred so that the most expensive part of the operation (\code{\link[=as.Date]{as.Date()}})
is applied only once.
}
\examples{
# will produce lints
lint(
  text = "c(log10(x), log10(y), log10(z))",
  linters = inner_combine_linter()
)

# okay
lint(
  text = "log10(c(x, y, z))",
  linters = inner_combine_linter()
)

lint(
  text = "c(log(x, base = 10), log10(x, base = 2))",
  linters = inner_combine_linter()
)

}
\seealso{
\link{linters} for a complete list of linters available in lintr.
}
\section{Tags}{
\link[=consistency_linters]{consistency}, \link[=efficiency_linters]{efficiency}, \link[=readability_linters]{readability}
}
