% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pptx_matrix.R
\name{as.matrix.rpptx}
\alias{as.matrix.rpptx}
\title{PowerPoint table to matrix}
\usage{
\method{as.matrix}{rpptx}(
  x,
  ...,
  slide_id = NA_integer_,
  id = NA_character_,
  span = c(NA_character_, "fill")
)
}
\arguments{
\item{x}{The rpptx object to convert (as created by
\code{officer::read_pptx()})}

\item{...}{Ignored}

\item{slide_id}{The slide number to load from (NA indicates first slide with
a table, NULL indicates all slides and all tables)}

\item{id}{The table ID to load from (ignored it \code{is.null(slide_id)}, NA
indicates to load the first table from the \code{slide_id})}

\item{span}{How should col_span/row_span values be handled?  \code{NA} means
to leave the value as \code{NA}, and \code{"fill"} means to fill matrix
cells with the value.}
}
\value{
A matrix with the data, or if \code{slide_id=NULL}, a list of
matrices
}
\description{
Convert the data in an a 'PowerPoint' table
to a matrix or all data to a list of matrices.
}
\examples{
library(officer)
pptx_file <- system.file(package="officer", "doc_examples", "example.pptx")
z <- read_pptx(pptx_file)
as.matrix(z, slide_id = NULL)
}
