# Announce: Rakudo Perl 6 compiler, Release #118 (2017.12)

On behalf of the Rakudo development team, I’m very happy to announce the
December 2017 release of Rakudo Perl 6 #118. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo.

Upcoming releases in 2017 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] — it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The changes in this release are outlined below:

New in 2017.12:
 + Fixes:
    + Various POD-related fixes [41514235][11d90cac][061c36d6][2cd266fe]
        [8ea7a46f][2c951798]
    + Fixed resolve of IO::Path for Windows [eed733e2]
    + Fixed ∖ op to do Hash→Mix conversion through Sets [eacf9b27]
    + Fixed incorrect attribute name in X::AdHoc.new [3166400d]
    + Fixed Supply.zip() to call `done` when some supply is `done` [1d0dae86]
    + Fixed Supply.throttle() when the source supply becomes `done` [c8370f21]
    + Fixed silent failures on invalid `is export` values [1668b4f0]
    + Fixed many cases of enum creation [d9021cf1][754664ed][65301756]
    + Fixed crash when using allomorphs as enum values [fc52143b]
    + Fixed <:Digit> to match digits correctly [0339b0f8]
    + Fixed some Telemetry.EXISTS-KEY issues [f3b1289f][91798547]
    + Fixed gut spillage in pseudopackages [cd24b1c5][a82e0e7d][1c7d15d7]
    + Fixed introspection on Mixins to Code:U objects [e31a414b]
    + Fixed let/temp to be able to take Mu [75229976]
    + Fixed autovivification container issues with `no strict` [e5b49ce3]
    + Fixed shaped array indexing to accept non-Ints [00632edb]
    + Fixed List.new to not create containers [d80df073]
    + Fixed incorrect .count-only/.bool-only implementation [af9812fa][0e228fab]
    + Made sure each Seq.skip gets a new Seq [854c10c2]
    + Moved attribute settage inside the lock [8df8ce09]
    + Made print/say/put/note handle junctions correctly [07616eff]
        [9de4a60e][8155c4b8][3405001d]
    + Fixed WhateverCode curries losing `use fatal` [31db3acc]
    + Various improvements to produced messages [d85585ea][9fd5042b]
        [c9699ab2][1da698ab]
 + Additions:
    + Implemented TR/// [f6958624][3d2fa915][8b27166f]
    + Implemented .toggle [694f534a][78caeb6b][ca7d0483][e7c0a644]
    + Consistified &[but] and &[does] with non-roles [575d31e2]
    + Added While/Until iterators [2c1a2860]
    + Added proper Supply.Seq method [aa3c2c5b]
 + Efficiency:
    + Made multi-needle split setup cheaper [5929887c]
    + Streamlined INDIRECT_NAME_LOOKUP a bit [76158136]
    + Made &[-]/&[+] with Rationals 30%-50% faster [6c299bf9]
    + Made DIVIDE-NUMBERS 6%-15% faster [78aeaf46]
    + Streamlined Hash.AT-KEY [6601da5c]
    + Streamlined Array.Slip.AT-POS like Hash.AT-KEY [fe8312b7]
    + Streamlined Array.AT-POS for better inlinability [af29a227]
    + Streamlined List.AT-POS a bit [9a2f5325]
    + Made Array.ASSIGN-POS about 1.7x faster [c5afc97e]
    + Made R:It:ReifiedArray 15% to 30% faster [a974de9b]
    + Streamlined Array.iterator.push-until-lazy a bit [ae02bc29]
 + Internal:
    + Abstracted prefix:<temp|let> logic into R:I [47f23fc6][126d7b55][6fb5c8c8]
    + Implemented Sequence.Numeric [6061f0bc]
    + Various improvements for the JVM backend [0a24efc3][f40c3818]
        [fbf7beca][928ada08][74a13ae1]
    + Added tests for previously resolved issues [20d67a3d][831dab14]
        [1b0be0f6][062c27f3][1101fea1][fed56be2][47552282][ced4af66]
        [d4ad6fa9][eaf609ed][04eb1da6]


The following people contributed to this release:

Zoffix Znet, Elizabeth Mattijsen, Pawel Murias, Alex Chen, Tom Browder,
Christian Bartolomäus, Luca Ferrari, Aleks-Daniel Jakimenko-Aleksejev,
Jan-Olof Hendig, Fernando Correa de Oliveira, Jeremy Studer,
Will "Coke" Coleda, Samantha McVey, Jonathan Worthington, Tim Smith,
Larry Wall, Dmitri Iouchtchenko, Rafael Schipiura, Fernando Correa,
Moritz Lenz, Timo Paulssen, Juan Julián Merelo Guervós, lefth, Brad Gilbert,
Michael D. Stemle, Jr, Daniel Green, Ronald Schmidt

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put “Perl 6 Core Development Fund” in the ‘Purpose’ text field)

The next release of Rakudo (#119), is tentatively scheduled for 2018-01-20.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback – get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, Perl 6 introductory
documentation, and other software that can be used with the Rakudo
compiler to enhance its utility.
