# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..10: "; }
END {print "not ok\n" unless $loaded;}
use RefDB::SRU;
$loaded = 1;
print "ok\n";

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

# set a few initial params
my $cuser = "";              # must match your database server
my $cpasswd = "";            # must match your database server
my $server_ip = "127.0.0.1"; # where refdbd runs
my $port = "9734";           # where refdbd listens
my $dbname = "refs";         # some reference database

# test counter
my $numtest = 1;
my $numok = 1;

## ask user for connection parameters
my $input;

print "This test script requires a running refdbd server that we can connect to. It also needs a RefDB database that contains a couple of references, and an user account that has read access to this database. Please provide the following connection parameters (hitting ENTER will use the defaults):\n\n";
print "username of a RefDB database user [$cuser]:";
chomp($input = <STDIN>);

if (length($input) > 0) {
    $cuser = $input;
}

print "password of a RefDB database user [$cpasswd]:";
chomp($input = <STDIN>);

if (length($input) > 0) {
    $cpasswd = $input;
}

print "IP address of refdbd server [$server_ip]:";
chomp($input = <STDIN>);

if (length($input) > 0) {
    $server_ip = $input;
}

print "port of refdbd server [$port]:";
chomp($input = <STDIN>);

if (length($input) > 0) {
    $port = $input;
}

print "name of a RefDB database [$dbname]:";
chomp($input = <STDIN>);

if (length($input) > 0) {
    $dbname = $input;
}

print "\n\n";

# set the parameters common for all tests
my %params = (
	      "loglevel" => "7",
	      "logdest" => "0",
	      "server_ip" => $server_ip,
	      "port" => $port,
	      "timeout" => "180",
	      "username" => $cuser,
	      "password" => $cpasswd,
	      "pdfroot" => "/home/foo/literature",
	      "css_url" => "/usr/local/share/refdb/css/refdb.css",
	      "database" => $dbname,
	      "version" => "1.1",
	      "maximumRecords" => "10",
	      "zeerex_host" => "my.example.com",
	      "zeerex_port" => "80",
	      "zeerex_database" => "refs",
	      "zeerex_databaseInfo_title" => "Reference Database",
	      "zeerex_databaseInfo_description" => "Reference Database",
	      "zeerex_databaseInfo_author" => "John Doe",
	      "zeerex_databaseInfo_contact" => "John\@Doe.org",
	      );

######################################################################
## Test module

######################################################################
# Test 2
print "2..4: explain operation";
$numtest++;

$params{'operation'} = "explain";

my $refdbquery = new RefDB::SRU(\%params);

$refdbquery->run();

my $result = $refdbquery->response();

if (length($result) > 0) {
    $numok++;
}

print "Content-type: text/xml\n\n";
print "$result\n";

######################################################################
# Test 3
print "3..4: searchRetrieve operation";
$numtest++;

$params{'operation'} = "searchRetrieve";
$params{'query'} = "bib.subject=A";

my $refdbquery = new RefDB::SRU(\%params);

$refdbquery->run();

my $result = $refdbquery->response();

if (length($result) > 0) {
    $numok++;
}

print "Content-type: text/xml\n\n";
print "$result\n";

######################################################################
# Test 4
print "4..4: scan operation";
$numtest++;

$params{'operation'} = "scan";
$params{'scanClause'} = "bib.subject=A";

my $refdbquery = new RefDB::SRU(\%params);

$refdbquery->run();

my $result = $refdbquery->response();

if (length($result) > 0) {
    $numok++;
}

print "Content-type: text/xml\n\n";
print "$result\n";

######################################################################
## Grand finale

print "That is ... waitaminute ... $numok out of $numtest\n";
