#!/bin/sh

set -e

package="ruby-wikicloth"

file=$(uscan --verbose | \
        sed -n '/Successfully downloaded updated package/ {s/.*updated package \(.*\)$/\1/; p}')
version="$(echo $file | sed 's/^v\(.*\)\.tar\.gz/\1/')+dfsg"
path=../$file

gzip -d < $path | \
    tar --delete --wildcards -f - '*/sample_documents/wiki.png' | \
    gzip > ../$package-$version.tar.gz
rm $path
echo "Repackaged ../$package-$version.tar.gz"
