You have created a reference to a mutable static.

Erroneous code example:

```compile_fail,edition2024,E0796
static mut X: i32 = 23;

fn work() {
  let _val = unsafe { X };
}

let x_ref = unsafe { &mut X };
work();
// The next line has Undefined Behavior!
// `x_ref` is a mutable reference and allows no aliases,
// but `work` has been reading the reference between
// the moment `x_ref` was created and when it was used.
// This violates the uniqueness of `x_ref`.
*x_ref = 42;
```

A reference to a mutable static has lifetime `'static`. This is very dangerous
as it is easy to accidentally overlap the lifetime of that reference with
other, conflicting accesses to the same static.

References to mutable statics are a hard error in the 2024 edition.
