#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 Mopi
# SPDX-FileCopyrightText: © 2019 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Gathering Sky
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251013.1

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='gathering-sky'
GAME_NAME='Gathering Sky'

ARCHIVE_BASE_0_NAME='GatheringSky_Linux_64bit.zip'
ARCHIVE_BASE_0_MD5='c590edce835070a1ac2ae47ac620dc48'
ARCHIVE_BASE_0_SIZE='1200000'
ARCHIVE_BASE_0_VERSION='1.0-humble1'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/gathering-sky'

CONTENT_PATH_DEFAULT='packr/linux/GatheringSky'
CONTENT_GAME_MAIN_FILES='
desktop-0.1.jar'

APP_MAIN_TYPE='java'
APP_MAIN_JAVA_OPTIONS='-Xmx1G'
APP_MAIN_EXE='desktop-0.1.jar'
APP_MAIN_ICONS_LIST='APP_MAIN_ICON_16 APP_MAIN_ICON_32 APP_MAIN_ICON_128'
APP_MAIN_ICON_16='../../../images/Icon_16.png'
APP_MAIN_ICON_32='../../../images/Icon_32.png'
APP_MAIN_ICON_128='../../../images/Icon_128.png'
## Ensure settings can be stored
APP_MAIN_PRERUN='
# Ensure settings can be stored.
mkdir --parents "${HOME}/.prefs"
'

## Easier upgrade from pre-20251013.1 packages
PKG_MAIN_PROVIDES='
gathering-sky
gathering-sky-data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

## The archive includes the following entry, triggering an error during decompression:
## ?rwxr--r--  2.0 unx        0 bl defN 14-May-31 03:43 /
archive_extraction_default 2>/dev/null || true
ARCHIVE_INNER_PATH="${PLAYIT_WORKDIR}/gamedata/GatheringSky.tar.gz"
archive_extraction 'ARCHIVE_INNER'
rm "$ARCHIVE_INNER_PATH"
## The icons are extracted from desktop-0.1.jar.
ARCHIVE_JAR_PATH="${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/desktop-0.1.jar"
ARCHIVE_JAR_TYPE='zip'
archive_extraction 'ARCHIVE_JAR'

# Include game data.

content_inclusion_icons
content_inclusion_default

# Write launchers.

## This game expects an executable stack through dynamically loaded libraries.
game_exec_line() {
	cat <<- 'EOF'
	GLIBC_TUNABLES=glibc.rtld.execstack=2 java -Xmx1G -jar desktop-0.1.jar "$@"
	EOF
}

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
