#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Contraption Maker
# send your bug reports to bugs@dotslashplay.it
###

script_version=20241210.1

PLAYIT_COMPATIBILITY_LEVEL='2.31'

GAME_ID='contraption-maker'
GAME_NAME='Contraption Maker'

ARCHIVE_BASE_GOG_1_NAME='contraption_maker_1_4_11_70403.sh'
ARCHIVE_BASE_GOG_1_MD5='14d482ccff969ae97cdf8d4b0d6d4f74'
ARCHIVE_BASE_GOG_1_SIZE='308082'
ARCHIVE_BASE_GOG_1_VERSION='1.4.11-gog70403'
ARCHIVE_BASE_GOG_1_URL='https://www.gog.com/game/contraption_maker'

ARCHIVE_BASE_GOG_0_NAME='contraption_maker_1_4_9_67880.sh'
ARCHIVE_BASE_GOG_0_MD5='8ab8c87a6d1a0e122ea9432a7a74d96c'
ARCHIVE_BASE_GOG_0_SIZE='320396'
ARCHIVE_BASE_GOG_0_VERSION='1.4.9.0-gog67880'

## This DRM-free installer is no longer available from humblebundle.com,
## they now only sell this game to Steam users.
ARCHIVE_BASE_HUMBLE_0_NAME='ContraptionMaker-linux-11410.sh'
ARCHIVE_BASE_HUMBLE_0_MD5='7d7a7a4a56cfff722d0654563aee482a'
ARCHIVE_BASE_HUMBLE_0_SIZE='251700'
ARCHIVE_BASE_HUMBLE_0_VERSION='1.0-humble.2015.04.07'

CONTENT_PATH_DEFAULT_GOG='data/noarch/game'
CONTENT_PATH_DEFAULT_HUMBLE='data'
CONTENT_GAME_BIN_RELATIVE_PATH_HUMBLE='x86_64'
CONTENT_GAME_BIN_FILES_GOG='
ContraptionMaker'
CONTENT_GAME_BIN_FILES_HUMBLE='
ContraptionMakerLauncher'
CONTENT_GAME_DATA_RELATIVE_PATH_HUMBLE='noarch'
CONTENT_GAME_DATA_FILES_GOG='
assets'
CONTENT_GAME_DATA_FILES_HUMBLE='
assets
ContraptionMakerPatcher_staging
ContraptionMaker_staging
icon.png'
CONTENT_DOC_DATA_RELATIVE_PATH_HUMBLE='noarch'
CONTENT_DOC_DATA_FILES_HUMBLE='
eula.txt'

APP_MAIN_EXE_GOG='ContraptionMaker'
APP_MAIN_EXE_HUMBLE='ContraptionMakerLauncher'
APP_MAIN_ICON_GOG='assets/gui/skins/default/mainmenu/mainmenu_logo_icon.png'
APP_MAIN_ICON_HUMBLE='noarch/icon.png'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libfontconfig.so.1
libgcc_s.so.1
libGL.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
libssl.so.1.0.0
libstdc++.so.6
libX11.so.6
libXcursor.so.1
libXinerama.so.1
libXi.so.6
libXrandr.so.2
libXxf86vm.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Work around a crash on XWayland due to the old shipped GLFW build
# cf. https://forge.dotslashplay.it/play.it/games-puzzle/-/issues/7
## TODO: Check if it is still required with the current game build

PRELOAD_HACKS_LIST='
HACK_XKBLIB'

HACK_XKBLIB_NAME='xkblib'
HACK_XKBLIB_DESCRIPTION='LD_PRELOAD shim working around a crash on XWayland due to the old shipped GLFW build
cf. https://forge.dotslashplay.it/play.it/games/-/issues/909'
HACK_XKBLIB_PACKAGE='PKG_BIN'
HACK_XKBLIB_SOURCE='
#define _GNU_SOURCE
#include <stdio.h>
#include <X11/XKBlib.h>

XkbDescPtr XkbGetKeyboard(Display *display, unsigned int _,
                          unsigned int device_spec)
{
	XkbDescPtr desc = XkbGetMap(display, 0, device_spec);
	XkbGetNames(display, XkbKeyNamesMask, desc);
	return desc;
}

void XkbFreeKeyboard(XkbDescPtr xkb, unsigned int which, Bool free_all)
{
	XkbFreeNames(xkb, XkbKeyNamesMask, free_all);
	XkbFreeClientMap(xkb, which, free_all);
}
'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Build and include the LD_PRELOAD shims

hacks_inclusion_default

# Extract game data

archive_extraction_default
(
	cd "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)"

	## gog.com - Convert the shipped icon to use a square ratio.
	case "$(current_archive)" in
		('ARCHIVE_BASE_GOG_'*)
			convert \
				-background none -gravity center "$(icon_path 'APP_MAIN_ICON')" \
				-resize 192x192 -extent 192x192 'temp_icon.png'
			mv 'temp_icon.png' "$(icon_path 'APP_MAIN_ICON')"
		;;
	esac

	## humblebundle.com - Convert the shipped icon to a smaller size.
	case "$(current_archive)" in
		('ARCHIVE_BASE_HUMBLE_'*)
			convert "$(icon_path 'APP_MAIN_ICON')" -resize 512x512 'temp_icon.png'
			mv 'temp_icon.png' "$(icon_path 'APP_MAIN_ICON')"
		;;
	esac
)

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
