## Usage

```js
var pretty = require('{%= name %}');

var start = process.hrtime();
var time = process.hrtime(start);
console.log(pretty(time));
//=> 3μs
```

## API

By default, when no time increment is given as the second argument, the closest timescale is used (e.g. _most granular without being less than zero_).

**Examples:**

```js
pretty([1200708, 795428088]);
//=> '2w'

pretty([800708, 795428088]);
//=> '1w'

pretty([400708, 795428088]);
//=> '5d'

pretty([70708, 795428088]);
//=> '20h'

pretty([12708, 795428088]);
//=> '4h'

pretty([3708, 795428088]);
//=> '1h'

pretty([208, 795428088]);
//=> '3m'

pretty([20, 795428088]);
//=> '21s'

pretty([0, 795428088]);
//=> '795ms'

pretty([0, 000428088]);
//=> '428μs'

pretty([0, 000000088]);
//=> '88ns'

pretty([0, 000000018]);
//=> '18ns'
```


### Minimum time increment

_(All of the following examples use `[6740, 795428088]` as the hrtime array.)_

This value is passed as the second argument and determines how granular to make the time.

**Examples**

```js
pretty(time, 'h');
//=> '2h'

pretty(time, 'm');
//=> '1h 52m'

pretty(time, 's');
//=> '1h 52m 21s'
```

**Valid time increments**

Any of the following may be used:

- `ns` | `nano` | `nanosecond` | `nanoseconds`
- `μs` | `micro` | `microsecond` | `microseconds`
- `ms` | `milli` | `millisecond` | `milliseconds`
- `s` | `sec` | `second` | `seconds`
- `m` | `min` | `minute` | `minutes`
- `h` | `hr` | `hour` | `hours`
- `d` | `day` | `days`
- `w` | `wk` | `week` | `weeks`
