% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unlink2.R
\name{dir.create2}
\alias{dir.create2}
\title{Safe directory construction}
\usage{
dir.create2(path, recursive = TRUE, ...)
}
\arguments{
\item{path, recursive, ...}{Further arguments to pass to \code{\link{dir.create}}.}
}
\value{
Either \code{path} is created or an error is raised.
\code{NULL} is invisibly returned.
}
\description{
Create a directory with an error message if it does not succeed.
}
\details{
This is primarily necessary to avoid incomprehensible errors when 
a directory cannot be created, usually due to insufficient permissions.
We set \code{recursive=TRUE} by default for convenience.

Note that the presence of an existing directory at \code{path}
will cause this function to fail.
This is usually desirable in the context of \pkg{basilisk.utils}
as stale directories should be \code{\link{unlink2}}ed beforehand.
}
\examples{
out <- tempfile()
dir.create2(out)

}
\seealso{
\code{\link{unlink2}}, for a similarly safe deletion function.
}
