% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/set_methods.R
\name{features_metadata}
\alias{features_metadata}
\alias{features_metadata<-}
\alias{features_metadata,MOFA-method}
\alias{features_metadata<-,MOFA,data.frame-method}
\title{features_metadata: set and retrieve feature metadata}
\usage{
features_metadata(object)

features_metadata(object) <- value

\S4method{features_metadata}{MOFA}(object)

\S4method{features_metadata}{MOFA,data.frame}(object) <- value
}
\arguments{
\item{object}{a \code{\link{MOFA}} object.}

\item{value}{data frame with feature information, it at least must contain the columns \code{feature} and \code{view}}
}
\value{
a data frame with sample metadata
}
\description{
features_metadata: set and retrieve feature metadata
}
\examples{
# Using an existing trained model on simulated data
file <- system.file("extdata", "model.hdf5", package = "MOFA2")
model <- load_model(file)
features_metadata(model)
}
