% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integer64.R
\name{cumsum.integer64}
\alias{cumsum.integer64}
\alias{diff.integer64}
\alias{cummin.integer64}
\alias{cummax.integer64}
\alias{cumprod.integer64}
\title{Cumulative Sums, Products, Extremes and lagged differences}
\usage{
\method{diff}{integer64}(x, lag = 1L, differences = 1L, ...)

\method{cummin}{integer64}(x)

\method{cummax}{integer64}(x)

\method{cumsum}{integer64}(x)

\method{cumprod}{integer64}(x)
}
\arguments{
\item{x}{an atomic vector of class 'integer64'}

\item{lag}{see \code{\link[=diff]{diff()}}}

\item{differences}{see \code{\link[=diff]{diff()}}}

\item{...}{ignored}
}
\value{
\code{\link[=cummin]{cummin()}}, \code{\link[=cummax]{cummax()}} , \code{\link[=cumsum]{cumsum()}} and \code{\link[=cumprod]{cumprod()}}
return a integer64 vector of the same length as their input

\code{\link[=diff]{diff()}} returns a integer64 vector shorter by \code{lag*differences} elements
}
\description{
Cumulative Sums, Products, Extremes and lagged differences
}
\examples{
  cumsum(rep(as.integer64(1), 12))
  diff(as.integer64(c(0,1:12)))
  cumsum(as.integer64(c(0, 1:12)))
  diff(cumsum(as.integer64(c(0,0,1:12))), differences=2)
}
\seealso{
\code{\link[=sum.integer64]{sum.integer64()}} \code{\link[=integer64]{integer64()}}
}
\keyword{classes}
\keyword{manip}
