require(hypergeo)

## Some random tests following complex ABC functionality.

## basic idea: create X, a 100x4 complex matrix with columns
## notionally A,B,C,z.  evaluate 2F1() on each row with the hypergeo
## package and SAGE and compare.  The comparison itself is right at
## the bottom of this file.


## X is a 100-by-4 matrix of complex numbers, created by
## latin.hypercube(100,4,complex=TRUE)


X <- 
structure(c(1.125-0.105i, -0.045+1.005i, -0.195+0.675i, 0.015-0.585i, 
-0.795+0.015i, 0.885-0.405i, -0.495-1.425i, -0.135-0.285i, -0.405+0.945i, 
-0.375-1.065i, -1.155+0.195i, 0.045+0.285i, -0.885-0.045i, -0.525+0.135i, 
-0.765+0.315i, 0.615+0.885i, 1.005-0.315i, 0.735-0.495i, -0.645+0.585i, 
0.975+0.705i, 0.705-0.915i, 1.395-0.165i, -1.245-1.485i, -0.915-1.455i, 
-1.425+0.765i, -0.855+0.735i, -1.395+0.345i, 0.315-0.825i, 0.825+0.225i, 
1.185+0.645i, 0.285-1.305i, 1.095-0.615i, -0.585+0.615i, 0.255+0.165i, 
-1.095+1.125i, -1.005+0.555i, 1.245+0.405i, -1.305-0.375i, -1.185-1.095i, 
0.405-0.765i, -0.555-1.035i, 1.455-1.395i, 0.915-0.345i, 0.555+0.045i, 
0.675-0.645i, -0.075+1.245i, -1.365+0.255i, -0.165-0.795i, 1.305+0.375i, 
1.065+0.825i, 0.465-0.135i, -0.285-0.555i, 0.375+1.185i, -0.675-0.015i, 
0.495-0.705i, 0.345+0.525i, 0.525-1.125i, 0.945+1.095i, 0.075+0.465i, 
-1.275+0.795i, 1.485+1.425i, 1.335-0.735i, -0.705+0.495i, -0.945-0.465i, 
-0.345-0.855i, -1.455+1.305i, -0.435+1.215i, -1.215-0.435i, -0.975+1.065i, 
0.435-1.155i, 0.585+1.485i, -1.125-0.255i, -1.485-0.945i, -1.035-1.215i, 
0.645+1.395i, 0.765-1.245i, 0.855-0.885i, 0.105-0.975i, -1.335+1.455i, 
0.135+1.275i, -0.315-1.185i, -0.225-0.225i, -0.015-0.675i, -0.735+1.035i, 
1.275+1.335i, 0.195-0.525i, -0.105+0.855i, 1.365-0.195i, 1.215-1.335i, 
1.035+0.105i, 1.155-1.005i, 0.165+0.435i, 0.795+1.155i, -1.065-0.075i, 
-0.825-1.275i, -0.465+1.365i, 1.425+0.075i, 0.225-1.365i, -0.255+0.915i, 
-0.615+0.975i, -0.705-0.825i, 0.225+0.165i, 0.765+1.245i, -0.375-1.335i, 
1.125-0.855i, -0.255+0.615i, 0.945+1.275i, -0.495+1.035i, 0.105-0.525i, 
-0.075+1.455i, -0.015-0.645i, 0.045-0.705i, -0.765+1.155i, 0.075-1.095i, 
-0.285-0.135i, 1.425+1.425i, 0.795+0.075i, 0.915+0.555i, 0.165+1.215i, 
-1.485+0.135i, 1.095+0.255i, -1.455-0.915i, -1.215-0.315i, -1.365+0.435i, 
-0.555+0.765i, -0.345+1.095i, -0.855-1.185i, 0.705-0.015i, 1.305-0.045i, 
-1.305-0.405i, 0.015+0.495i, -1.395+1.125i, -0.315-1.365i, -0.225+0.915i, 
-0.915-1.245i, 0.645-0.375i, 0.525-0.345i, -0.045+0.795i, -1.335+0.675i, 
-0.795-1.005i, -0.885-1.455i, 0.345+0.585i, 1.335+0.195i, -0.105-0.615i, 
1.245+0.735i, 1.005-1.065i, 1.275-0.105i, 0.825+0.405i, -0.405+1.395i, 
-0.735+1.065i, 0.495+0.225i, -1.275+0.315i, -0.435+0.015i, -1.185-1.035i, 
-1.005-0.975i, 0.375-0.555i, 1.215-1.215i, 0.465+1.005i, -0.465-1.395i, 
0.255+0.375i, -1.065-0.195i, -0.945-0.465i, 1.035-0.765i, 1.185-0.885i, 
1.485+0.885i, 0.885+0.525i, 0.195+0.645i, 0.735-1.125i, 1.455+1.485i, 
-0.615-0.795i, -0.165-0.945i, 1.155+0.975i, 0.285-1.425i, 0.675-1.275i, 
-1.245+1.185i, -0.645-1.305i, 0.135+0.825i, 0.435+0.945i, -0.675-0.165i, 
-1.095-0.435i, -1.155+0.045i, 1.365-0.225i, -1.125-1.155i, 1.395-0.585i, 
-0.525+0.855i, -1.425+0.105i, 0.315-0.735i, 0.975+0.465i, 0.555+1.305i, 
0.405-0.285i, -1.035+0.345i, -0.825+0.285i, 0.855-0.495i, -0.195+1.365i, 
0.585-0.255i, -0.135-1.485i, -0.975+1.335i, -0.585+0.705i, 0.615-0.075i, 
1.065-0.675i, -0.825-0.675i, -0.345+0.915i, 0.825+0.735i, -0.765-1.125i, 
-1.455+0.105i, 0.735-0.075i, 0.795+0.345i, 0.015-0.855i, 0.225-0.165i, 
-1.035+1.125i, 1.125-0.975i, 1.095-0.135i, 0.855-0.315i, 0.705-1.275i, 
-0.375+0.495i, -0.555+0.435i, -0.645+1.335i, 1.215-0.705i, -1.065-0.795i, 
1.275-0.495i, 1.485+0.615i, 0.495+1.095i, 0.465-0.915i, 0.105-0.885i, 
-0.735-0.825i, 1.065+1.155i, 0.165+0.225i, -1.155-0.225i, 0.345+1.395i, 
-0.465-0.525i, -0.435-1.485i, 0.645-0.255i, 0.945+0.165i, -1.275-0.345i, 
-0.615-1.395i, -0.255+0.825i, -1.425-1.095i, -0.915+1.275i, -0.075-0.375i, 
-0.015+0.0750000000000001i, -0.225-0.435i, -0.105-1.425i, -0.285-0.195i, 
1.425+0.465i, 1.305-1.005i, -1.365-0.465i, 1.185+1.305i, -0.585-0.945i, 
-1.185-1.335i, 1.005+1.245i, 0.675+0.555i, 0.315-0.285i, -0.195-1.155i, 
0.255-0.765i, 0.885-0.045i, 0.405-1.365i, -0.705-1.215i, 1.155+0.195i, 
-0.525+1.455i, -0.885+0.015i, -1.305+0.285i, -1.095+0.525i, -1.335+0.135i, 
-1.485+1.035i, 0.615+1.185i, -0.855-0.405i, 0.915-0.105i, -0.975-1.455i, 
0.555+0.975i, 0.765+1.065i, -0.135+0.945i, 1.455+0.705i, 0.585+1.005i, 
0.435+0.855i, 1.395+1.215i, 1.365+0.765i, -0.675+0.885i, -0.045-0.735i, 
-0.315-0.615i, -1.245+1.425i, -0.405+1.485i, 0.975-1.305i, 0.075+0.585i, 
1.245+0.315i, 0.135-1.035i, 0.045+1.365i, 0.375+0.675i, 0.525-1.185i, 
-0.165-0.555i, -0.495+0.045i, -0.795+0.795i, 1.035-1.065i, -0.945+0.375i, 
1.335-0.585i, -1.005-0.015i, -1.395+0.405i, -1.215-1.245i, 0.285+0.255i, 
-1.125-0.645i, 0.195+0.645i, 0.135+0.285i, 1.305-1.305i, -0.465+0.165i, 
1.215-1.035i, -0.195+0.915i, 0.495+0.525i, 0.525+0.195i, 0.765-1.335i, 
-1.035+0.435i, -0.495+1.245i, 0.225-0.345i, 0.375-0.225i, -0.825+0.075i, 
-0.795-1.245i, 1.155+0.105i, -0.945+1.455i, 1.185-0.885i, 0.885+1.335i, 
0.435-1.125i, -0.045+1.395i, -1.425+0.615i, -0.105-0.615i, 0.795+0.885i, 
-1.095+0.345i, -0.435-0.015i, 0.285-0.915i, -0.075-0.525i, -0.975+0.765i, 
0.975-0.705i, 1.095+0.375i, 1.485+1.005i, 1.065+0.225i, 1.275-0.435i, 
1.425-0.645i, 1.125-0.045i, 0.405+1.035i, -0.885+0.645i, 0.675-0.975i, 
-0.285+0.555i, -0.855+1.305i, -1.125-0.465i, -0.525+0.495i, -1.155+1.095i, 
1.455+0.135i, -0.315-0.285i, 0.045-1.215i, -1.365+0.405i, 1.245+0.855i, 
0.855-0.075i, 0.645+0.975i, -0.375+0.675i, 1.395-0.405i, -0.135+1.485i, 
-0.225-0.795i, -1.395-0.855i, 0.075+0.825i, -1.485-0.135i, -0.915-0.375i, 
-1.065-1.455i, 0.465+1.125i, 0.915-1.425i, -1.185+0.465i, 0.315+1.185i, 
-0.555+0.315i, -1.335+1.365i, -1.245-0.315i, 0.195-0.165i, -0.405+1.275i, 
0.735-1.005i, 0.015+1.065i, -1.305+0.945i, 0.945-0.735i, -0.645+0.045i, 
0.255-0.675i, -0.705-0.555i, -1.455+0.735i, -1.005+0.015i, -0.735+1.155i, 
0.105-1.395i, 0.615-0.945i, 1.335+0.255i, 0.705+0.585i, -0.165-0.495i, 
-1.275-1.095i, -0.015-0.255i, 0.165-1.065i, -0.765-1.275i, 0.585-1.185i, 
1.005+0.795i, -0.615-0.825i, -0.585+0.705i, 0.345-1.365i, 1.035-0.765i, 
-0.255-0.585i, -1.215-1.155i, 0.825-0.105i, 0.555-1.485i, -0.675+1.215i, 
1.365-0.195i, -0.345+1.425i), .Dim = c(100L, 4L))



## Following string created by dicking about with X in emacs
## (replacing 'i' with 'I' and changing the brackets etc etc):

sage_executable_string <- '
e = [
hypergeometric([  1.125-0.105*I, -0.705-0.825*I],[ -0.825-0.675*I],  0.135+0.285*I),
hypergeometric([ -0.045+1.005*I,  0.225+0.165*I],[ -0.345+0.915*I],  1.305-1.305*I),
hypergeometric([ -0.195+0.675*I,  0.765+1.245*I],[  0.825+0.735*I], -0.465+0.165*I),
hypergeometric([  0.015-0.585*I, -0.375-1.335*I],[ -0.765-1.125*I],  1.215-1.035*I),
hypergeometric([ -0.795+0.015*I,  1.125-0.855*I],[ -1.455+0.105*I], -0.195+0.915*I),
hypergeometric([  0.885-0.405*I, -0.255+0.615*I],[  0.735-0.075*I],  0.495+0.525*I),
hypergeometric([ -0.495-1.425*I,  0.945+1.275*I],[  0.795+0.345*I],  0.525+0.195*I),
hypergeometric([ -0.135-0.285*I, -0.495+1.035*I],[  0.015-0.855*I],  0.765-1.335*I),
hypergeometric([ -0.405+0.945*I,  0.105-0.525*I],[  0.225-0.165*I], -1.035+0.435*I),
hypergeometric([ -0.375-1.065*I, -0.075+1.455*I],[ -1.035+1.125*I], -0.495+1.245*I),
hypergeometric([ -1.155+0.195*I, -0.015-0.645*I],[  1.125-0.975*I],  0.225-0.345*I),
hypergeometric([  0.045+0.285*I,  0.045-0.705*I],[  1.095-0.135*I],  0.375-0.225*I),
hypergeometric([ -0.885-0.045*I, -0.765+1.155*I],[  0.855-0.315*I], -0.825+0.075*I),
hypergeometric([ -0.525+0.135*I,  0.075-1.095*I],[  0.705-1.275*I], -0.795-1.245*I),
hypergeometric([ -0.765+0.315*I, -0.285-0.135*I],[ -0.375+0.495*I],  1.155+0.105*I),
hypergeometric([  0.615+0.885*I,  1.425+1.425*I],[ -0.555+0.435*I], -0.945+1.455*I),
hypergeometric([  1.005-0.315*I,  0.795+0.075*I],[ -0.645+1.335*I],  1.185-0.885*I),
hypergeometric([  0.735-0.495*I,  0.915+0.555*I],[  1.215-0.705*I],  0.885+1.335*I),
hypergeometric([ -0.645+0.585*I,  0.165+1.215*I],[ -1.065-0.795*I],  0.435-1.125*I),
hypergeometric([  0.975+0.705*I, -1.485+0.135*I],[  1.275-0.495*I], -0.045+1.395*I),
hypergeometric([  0.705-0.915*I,  1.095+0.255*I],[  1.485+0.615*I], -1.425+0.615*I),
hypergeometric([  1.395-0.165*I, -1.455-0.915*I],[  0.495+1.095*I], -0.105-0.615*I),
hypergeometric([ -1.245-1.485*I, -1.215-0.315*I],[  0.465-0.915*I],  0.795+0.885*I),
hypergeometric([ -0.915-1.455*I, -1.365+0.435*I],[  0.105-0.885*I], -1.095+0.345*I),
hypergeometric([ -1.425+0.765*I, -0.555+0.765*I],[ -0.735-0.825*I], -0.435-0.015*I),
hypergeometric([ -0.855+0.735*I, -0.345+1.095*I],[  1.065+1.155*I],  0.285-0.915*I),
hypergeometric([ -1.395+0.345*I, -0.855-1.185*I],[  0.165+0.225*I], -0.075-0.525*I),
hypergeometric([  0.315-0.825*I,  0.705-0.015*I],[ -1.155-0.225*I], -0.975+0.765*I),
hypergeometric([  0.825+0.225*I,  1.305-0.045*I],[  0.345+1.395*I],  0.975-0.705*I),
hypergeometric([  1.185+0.645*I, -1.305-0.405*I],[ -0.465-0.525*I],  1.095+0.375*I),
hypergeometric([  0.285-1.305*I,  0.015+0.495*I],[ -0.435-1.485*I],  1.485+1.005*I),
hypergeometric([  1.095-0.615*I, -1.395+1.125*I],[  0.645-0.255*I],  1.065+0.225*I),
hypergeometric([ -0.585+0.615*I, -0.315-1.365*I],[  0.945+0.165*I],  1.275-0.435*I),
hypergeometric([  0.255+0.165*I, -0.225+0.915*I],[ -1.275-0.345*I],  1.425-0.645*I),
hypergeometric([ -1.095+1.125*I, -0.915-1.245*I],[ -0.615-1.395*I],  1.125-0.045*I),
hypergeometric([ -1.005+0.555*I,  0.645-0.375*I],[ -0.255+0.825*I],  0.405+1.035*I),
hypergeometric([  1.245+0.405*I,  0.525-0.345*I],[ -1.425-1.095*I], -0.885+0.645*I),
hypergeometric([ -1.305-0.375*I, -0.045+0.795*I],[ -0.915+1.275*I],  0.675-0.975*I),
hypergeometric([ -1.185-1.095*I, -1.335+0.675*I],[ -0.075-0.375*I], -0.285+0.555*I),
hypergeometric([  0.405-0.765*I, -0.795-1.005*I],[ -0.015+0.075*I], -0.855+1.305*I),
hypergeometric([ -0.555-1.035*I, -0.885-1.455*I],[ -0.225-0.435*I], -1.125-0.465*I),
hypergeometric([  1.455-1.395*I,  0.345+0.585*I],[ -0.105-1.425*I], -0.525+0.495*I),
hypergeometric([  0.915-0.345*I,  1.335+0.195*I],[ -0.285-0.195*I], -1.155+1.095*I),
hypergeometric([  0.555+0.045*I, -0.105-0.615*I],[  1.425+0.465*I],  1.455+0.135*I),
hypergeometric([  0.675-0.645*I,  1.245+0.735*I],[  1.305-1.005*I], -0.315-0.285*I),
hypergeometric([ -0.075+1.245*I,  1.005-1.065*I],[ -1.365-0.465*I],  0.045-1.215*I),
hypergeometric([ -1.365+0.255*I,  1.275-0.105*I],[  1.185+1.305*I], -1.365+0.405*I),
hypergeometric([ -0.165-0.795*I,  0.825+0.405*I],[ -0.585-0.945*I],  1.245+0.855*I),
hypergeometric([  1.305+0.375*I, -0.405+1.395*I],[ -1.185-1.335*I],  0.855-0.075*I),
hypergeometric([  1.065+0.825*I, -0.735+1.065*I],[  1.005+1.245*I],  0.645+0.975*I),
hypergeometric([  0.465-0.135*I,  0.495+0.225*I],[  0.675+0.555*I], -0.375+0.675*I),
hypergeometric([ -0.285-0.555*I, -1.275+0.315*I],[  0.315-0.285*I],  1.395-0.405*I),
hypergeometric([  0.375+1.185*I, -0.435+0.015*I],[ -0.195-1.155*I], -0.135+1.485*I),
hypergeometric([ -0.675-0.015*I, -1.185-1.035*I],[  0.255-0.765*I], -0.225-0.795*I),
hypergeometric([  0.495-0.705*I, -1.005-0.975*I],[  0.885-0.045*I], -1.395-0.855*I),
hypergeometric([  0.345+0.525*I,  0.375-0.555*I],[  0.405-1.365*I],  0.075+0.825*I),
hypergeometric([  0.525-1.125*I,  1.215-1.215*I],[ -0.705-1.215*I], -1.485-0.135*I),
hypergeometric([  0.945+1.095*I,  0.465+1.005*I],[  1.155+0.195*I], -0.915-0.375*I),
hypergeometric([  0.075+0.465*I, -0.465-1.395*I],[ -0.525+1.455*I], -1.065-1.455*I),
hypergeometric([ -1.275+0.795*I,  0.255+0.375*I],[ -0.885+0.015*I],  0.465+1.125*I),
hypergeometric([  1.485+1.425*I, -1.065-0.195*I],[ -1.305+0.285*I],  0.915-1.425*I),
hypergeometric([  1.335-0.735*I, -0.945-0.465*I],[ -1.095+0.525*I], -1.185+0.465*I),
hypergeometric([ -0.705+0.495*I,  1.035-0.765*I],[ -1.335+0.135*I],  0.315+1.185*I),
hypergeometric([ -0.945-0.465*I,  1.185-0.885*I],[ -1.485+1.035*I], -0.555+0.315*I),
hypergeometric([ -0.345-0.855*I,  1.485+0.885*I],[  0.615+1.185*I], -1.335+1.365*I),
hypergeometric([ -1.455+1.305*I,  0.885+0.525*I],[ -0.855-0.405*I], -1.245-0.315*I),
hypergeometric([ -0.435+1.215*I,  0.195+0.645*I],[  0.915-0.105*I],  0.195-0.165*I),
hypergeometric([ -1.215-0.435*I,  0.735-1.125*I],[ -0.975-1.455*I], -0.405+1.275*I),
hypergeometric([ -0.975+1.065*I,  1.455+1.485*I],[  0.555+0.975*I],  0.735-1.005*I),
hypergeometric([  0.435-1.155*I, -0.615-0.795*I],[  0.765+1.065*I],  0.015+1.065*I),
hypergeometric([  0.585+1.485*I, -0.165-0.945*I],[ -0.135+0.945*I], -1.305+0.945*I),
hypergeometric([ -1.125-0.255*I,  1.155+0.975*I],[  1.455+0.705*I],  0.945-0.735*I),
hypergeometric([ -1.485-0.945*I,  0.285-1.425*I],[  0.585+1.005*I], -0.645+0.045*I),
hypergeometric([ -1.035-1.215*I,  0.675-1.275*I],[  0.435+0.855*I],  0.255-0.675*I),
hypergeometric([  0.645+1.395*I, -1.245+1.185*I],[  1.395+1.215*I], -0.705-0.555*I),
hypergeometric([  0.765-1.245*I, -0.645-1.305*I],[  1.365+0.765*I], -1.455+0.735*I),
hypergeometric([  0.855-0.885*I,  0.135+0.825*I],[ -0.675+0.885*I], -1.005+0.015*I),
hypergeometric([  0.105-0.975*I,  0.435+0.945*I],[ -0.045-0.735*I], -0.735+1.155*I),
hypergeometric([ -1.335+1.455*I, -0.675-0.165*I],[ -0.315-0.615*I],  0.105-1.395*I),
hypergeometric([  0.135+1.275*I, -1.095-0.435*I],[ -1.245+1.425*I],  0.615-0.945*I),
hypergeometric([ -0.315-1.185*I, -1.155+0.045*I],[ -0.405+1.485*I],  1.335+0.255*I),
hypergeometric([ -0.225-0.225*I,  1.365-0.225*I],[  0.975-1.305*I],  0.705+0.585*I),
hypergeometric([ -0.015-0.675*I, -1.125-1.155*I],[  0.075+0.585*I], -0.165-0.495*I),
hypergeometric([ -0.735+1.035*I,  1.395-0.585*I],[  1.245+0.315*I], -1.275-1.095*I),
hypergeometric([  1.275+1.335*I, -0.525+0.855*I],[  0.135-1.035*I], -0.015-0.255*I),
hypergeometric([  0.195-0.525*I, -1.425+0.105*I],[  0.045+1.365*I],  0.165-1.065*I),
hypergeometric([ -0.105+0.855*I,  0.315-0.735*I],[  0.375+0.675*I], -0.765-1.275*I),
hypergeometric([  1.365-0.195*I,  0.975+0.465*I],[  0.525-1.185*I],  0.585-1.185*I),
hypergeometric([  1.215-1.335*I,  0.555+1.305*I],[ -0.165-0.555*I],  1.005+0.795*I),
hypergeometric([  1.035+0.105*I,  0.405-0.285*I],[ -0.495+0.045*I], -0.615-0.825*I),
hypergeometric([  1.155-1.005*I, -1.035+0.345*I],[ -0.795+0.795*I], -0.585+0.705*I),
hypergeometric([  0.165+0.435*I, -0.825+0.285*I],[  1.035-1.065*I],  0.345-1.365*I),
hypergeometric([  0.795+1.155*I,  0.855-0.495*I],[ -0.945+0.375*I],  1.035-0.765*I),
hypergeometric([ -1.065-0.075*I, -0.195+1.365*I],[  1.335-0.585*I], -0.255-0.585*I),
hypergeometric([ -0.825-1.275*I,  0.585-0.255*I],[ -1.005-0.015*I], -1.215-1.155*I),
hypergeometric([ -0.465+1.365*I, -0.135-1.485*I],[ -1.395+0.405*I],  0.825-0.105*I),
hypergeometric([  1.425+0.075*I, -0.975+1.335*I],[ -1.215-1.245*I],  0.555-1.485*I),
hypergeometric([  0.225-1.365*I, -0.585+0.705*I],[  0.285+0.255*I], -0.675+1.215*I),
hypergeometric([ -0.255+0.915*I,  0.615-0.075*I],[ -1.125-0.645*I],  1.365-0.195*I),
hypergeometric([ -0.615+0.975*I,  1.065-0.675*I],[  0.195+0.645*I], -0.345+1.425*I)
]
'


## cut-and-paste sage_executable_string into a SAGE window gives
## jj_SAGE (edited with I -> i):


jj_SAGE <- 
c(0.964064283226315+0.406653008068512i, 0.82707630709444-0.370937724712521i, 
1.03665840072975-0.3745212608222i, 0.311643703830213-0.059274615332188i, 
1.31889143955355+0.98358042791712i, 0.405991168469753+0.149172050853617i, 
1.87643152586246-2.80581039288231i, 2.31668177317317+0.51808387102652i, 
-0.122242638166958-0.889392940337358i, 3.48742528089186+0.25722971358896i, 
1.09149744311818+0.19127398917714i, 1.07163539691245-0.05300137850522i, 
0.157278990462089+0.704913476143799i, 1.52372342748309+0.08141771931798i, 
0.785885092880626-0.715360264471072i, 0.0216589720824476-0.0909138810740614i, 
0.660292972492823+0.014427094192097i, 0.44365002761559+0.444956277452165i, 
4.04716561018481+1.24056810636042i, 2.37644068967706-1.57058677283954i, 
0.558708534227811+0.552972309397236i, 1.61529969818653+1.03188241118319i, 
-1.18553386183283+0.5873259941393i, 0.99707322673383-2.931234926817i, 
0.680537291441649-0.579859026216333i, 0.360307597830038+0.720860521050483i, 
-0.98864157728245-3.81406419088578i, 0.252378131800944-0.59485905993533i, 
0.59607084069452-0.219279157536749i, 8.07056701558553+1.69193967395666i, 
0.591882294649085-0.015407505666751i, -0.27845178964472-0.294537366690991i, 
3.05817793180882-0.72462649950454i, 16.2521832241482-20.2361474982059i, 
-0.181862582317452-0.433332189593273i, 0.727885438186042+0.791476216373831i, 
0.817934672410365-0.262095371823089i, 0.61702897081267+0.655148620096229i, 
-0.52394309041368-2.63565076599397i, -31.9139401895563-33.1654441589648i, 
-2.13889175070336+4.69195794872461i, 0.786720584231085-0.323249180201461i, 
0.855588219574382+0.101460109860437i, 0.55143104013356-1.17603120124834i, 
0.819637168256866-0.227520793569102i, 7.1799623048675+10.3182615358612i, 
0.95175079521714-1.51253931246129i, 0.899191744605859+0.23657949532331i, 
5.271856129022+15.5815808330552i, 0.23090696141459-0.092282020024552i, 
0.938040796485748+0.181990900185989i, 0.97991214712222+3.1081575617022i, 
1.10429507061501+0.49370463840104i, 1.98809909889486+0.1461532999329i, 
2.32132164645484+1.62938720492934i, 0.821895979655106+0.025840438361425i, 
0.325656443632889+0.048639723489158i, 1.01029957861379-1.06586185742231i, 
0.646924915944423+0.47861895492059i, 2.3202408170565-1.38911193361353i, 
3.26464342908096-0.17114816861882i, -2.38013878749958-0.40190105182197i, 
1.88172724303743+1.84516328918703i, 0.309289851889681+0.201725756721228i, 
2.77286446038373+1.49246790054942i, -10.1594995553928+10.2739461027359i, 
0.763034620971341+0.107973239735447i, 2.34319552106844+0.77122914409054i, 
6.27802111299288+9.95066213638639i, -0.629648059040542-0.211092963199809i, 
1.65840108157949+1.8550938256919i, -0.03642866072188+0.244808831053446i, 
0.23839817784176-1.79703341141231i, 1.77328707798733+1.16541168167425i, 
2.72908872242441+0.16799152205788i, 4.43587814415038-1.21335879049252i, 
0.664271836551866+0.443536151535508i, 0.371286221002016-0.335697816131313i, 
5.64737925282143+0.29569188173276i, 0.770694632252336+0.754808096824131i, 
2.32750791275625-0.720203430679i, 1.23980860450053-0.13021457000086i, 
1.70821635799758-0.65433153788405i, 1.0182178250073-2.32666645018147i, 
0.46512140584495+0.150738899313962i, 1.33353226705637-0.65264869464624i, 
0.237136870625582-0.102317163592682i, 2.10049091617389-3.27378187966606i, 
-1.24807067982028+3.72049884771884i, 0.990535784678856-0.129343699776059i, 
0.417982637548751+0.74514898992668i, 0.58491978827329-0.165071348419987i, 
-31.0175228903646+5.7494155404184i, 0.383535688404315-0.133653115051991i, 
-39.815038090154+5.2725591296696i, 23.1846732282934-14.9574359998481i, 
-3.7118537540819-38.2041364504503i, -1.46775864170983+1.24783866808145i, 
-6.888415221581-146.849491142663i, -0.159710724756269+0.646598941671109i
)
  

# now perform the actual comparison:

f <- function(x){hypergeo(x[1],x[2],x[3],x[4])}
jj_R <- apply(X,1,f)

stopifnot(all(abs(jj_R - jj_SAGE) < 1e-10))  # actual accuracy is higher
