% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_if.R
\name{color_if}
\alias{color_if}
\alias{colour_if}
\title{Color-formatting for data columns based on condition}
\usage{
color_if(
  x,
  columns,
  predicate = `>`,
  value = 0,
  color_if = "green",
  color_else = "red",
  digits = 2
)

colour_if(
  x,
  columns,
  predicate = `>`,
  value = 0,
  colour_if = "green",
  colour_else = "red",
  digits = 2
)
}
\arguments{
\item{x}{A data frame}

\item{columns}{Character vector with column names of \code{x} that should be formatted.}

\item{predicate}{A function that takes \code{columns} and \code{value} as input
and which should return \code{TRUE} or \code{FALSE}, based on if the condition
(in comparison with \code{value}) is met.}

\item{value}{The comparator. May be used in conjunction with \code{predicate}
to quickly set up a function which compares elements in \code{colums} to \code{value}.
May be ignored when \code{predicate} is a function that internally computes other
comparisons. See 'Examples'.}

\item{color_if, colour_if}{Character vector, indicating the color code used to
format values in \code{x} that meet the condition of \code{predicate} and \code{value}.
May be one of \code{"red"}, \code{"yellow"}, \code{"green"}, \code{"blue"},
\code{"violet"}, \code{"cyan"} or \code{"grey"}. Formatting is also possible
with \code{"bold"} or \code{"italic"}.}

\item{color_else, colour_else}{See \code{color_if}, but only for conditions
that are \emph{not} met.}

\item{digits}{Digits for rounded values.}
}
\value{
The .
}
\description{
Convenient function that formats columns in data frames
with color codes, where the color is chosen based on certain conditions.
Columns are then printed in color in the console.
}
\details{
The predicate-function simply works like this:
\code{which(predicate(x[, columns], value))}
}
\examples{
# all values in Sepal.Length larger than 5 in green, all remaining in red
x <- color_if(iris[1:10, ], columns = "Sepal.Length", predicate = `>`, value = 5)
x
cat(x$Sepal.Length)

# all levels "setosa" in Species in green, all remaining in red
x <- color_if(iris, columns = "Species", predicate = `==`, value = "setosa")
cat(x$Species)

# own function, argument "value" not needed here
p <- function(x, y) {
  x >= 4.9 & x <= 5.1
}
# all values in Sepal.Length between 4.9 and 5.1 in green, all remaining in red
x <- color_if(iris[1:10, ], columns = "Sepal.Length", predicate = p)
cat(x$Sepal.Length)
}
