% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{msm.form.qoutput}
\alias{msm.form.qoutput}
\alias{msm.form.eoutput}
\title{Extract msm model parameter estimates in compact format}
\usage{
msm.form.qoutput(x, covariates = "mean", cl = 0.95, digits = 4, ...)

msm.form.eoutput(x, covariates = "mean", cl = 0.95, digits = 4, ...)
}
\arguments{
\item{x}{A fitted multi-state model object, as returned by
\code{\link{msm}}.}

\item{covariates}{Covariate values defining the "baseline" parameters (see
\code{\link{qmatrix.msm}}).}

\item{cl}{Width of the symmetric confidence interval to present.  Defaults
to 0.95.}

\item{digits}{Minimum number of significant digits for the formatted
character matrix returned as an attribute.  This is passed to
\code{\link{format}}. Defaults to 4.}

\item{...}{Other arguments to be passed to \code{\link{format}}.}
}
\value{
A numeric matrix with one row per transition, and one column for
each estimate or confidence limit.  The \code{"formatted"} attribute
contains the same results formatted for pretty printing.
\code{msm.form.qoutput} returns the transition intensities and their
covariates, and \code{msm.form.eoutput} returns the misclassification
probabilities and their covariates.
}
\description{
Extract estimates and confidence intervals for transition intensities (or
misclassification probabilities), and their covariate effects, in a tidy
matrix format with one row per transition.  This is used by the print method
(\code{\link{print.msm}}) for \code{msm} objects.  Covariate effects are
returned as hazard or odds ratios, not on the log scale.
}
\seealso{
\code{\link{print.msm}}
}
\author{
C. H. Jackson \email{chris.jackson@mrc-bsu.cam.ac.uk}
}
\keyword{models}
