% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeData.R
\name{writeData}
\alias{writeData}
\title{Write an object to a worksheet}
\usage{
writeData(
  wb,
  sheet,
  x,
  startCol = 1,
  startRow = 1,
  array = FALSE,
  xy = NULL,
  colNames = TRUE,
  rowNames = FALSE,
  headerStyle = openxlsx_getOp("headerStyle"),
  borders = openxlsx_getOp("borders", "none"),
  borderColour = openxlsx_getOp("borderColour", "black"),
  borderStyle = openxlsx_getOp("borderStyle", "thin"),
  withFilter = openxlsx_getOp("withFilter", FALSE),
  keepNA = openxlsx_getOp("keepNA", FALSE),
  na.string = openxlsx_getOp("na.string"),
  name = NULL,
  sep = ", ",
  col.names,
  row.names
)
}
\arguments{
\item{wb}{A Workbook object containing a worksheet.}

\item{sheet}{The worksheet to write to. Can be the worksheet index or name.}

\item{x}{Object to be written. For classes supported look at the examples.}

\item{startCol}{A vector specifying the starting column to write to.}

\item{startRow}{A vector specifying the starting row to write to.}

\item{array}{A bool if the function written is of type array}

\item{xy}{An alternative to specifying \code{startCol} and
\code{startRow} individually.  A vector of the form
\code{c(startCol, startRow)}.}

\item{colNames}{If \code{TRUE}, column names of x are written.}

\item{rowNames}{If \code{TRUE}, data.frame row names of x are written.}

\item{headerStyle}{Custom style to apply to column names.}

\item{borders}{Either "\code{none}" (default), "\code{surrounding}",
"\code{columns}", "\code{rows}" or \emph{respective abbreviations}.  If
"\code{surrounding}", a border is drawn around the data.  If "\code{rows}",
a surrounding border is drawn with a border around each row. If
"\code{columns}", a surrounding border is drawn with a border between
each column. If "\code{all}" all cell borders are drawn.}

\item{borderColour}{Colour of cell border.  A valid colour (belonging to \code{colours()} or a hex colour code, eg see \href{https://www.w3schools.com/colors/colors_picker.asp}{here}).}

\item{borderStyle}{Border line style
\itemize{
\item{\strong{none}}{ no border}
\item{\strong{thin}}{ thin border}
\item{\strong{medium}}{ medium border}
\item{\strong{dashed}}{ dashed border}
\item{\strong{dotted}}{ dotted border}
\item{\strong{thick}}{ thick border}
\item{\strong{double}}{ double line border}
\item{\strong{hair}}{ hairline border}
\item{\strong{mediumDashed}}{ medium weight dashed border}
\item{\strong{dashDot}}{ dash-dot border}
\item{\strong{mediumDashDot}}{ medium weight dash-dot border}
\item{\strong{dashDotDot}}{ dash-dot-dot border}
\item{\strong{mediumDashDotDot}}{ medium weight dash-dot-dot border}
\item{\strong{slantDashDot}}{ slanted dash-dot border}
}}

\item{withFilter}{If \code{TRUE} or \code{NA}, add filters to the column name row. NOTE can only have one filter per worksheet.}

\item{keepNA}{If \code{TRUE}, NA values are converted to #N/A (or \code{na.string}, if not NULL) in Excel, else NA cells will be empty.}

\item{na.string}{If not NULL, and if \code{keepNA} is \code{TRUE}, NA values are converted to this string in Excel.}

\item{name}{If not NULL, a named region is defined.}

\item{sep}{Only applies to list columns. The separator used to collapse list columns to a character vector e.g. sapply(x$list_column, paste, collapse = sep).}

\item{row.names, col.names}{Deprecated, please use \code{rowNames}, \code{colNames} instead}
}
\value{
invisible(0)
}
\description{
Write an object to worksheet with optional styling.
}
\details{
Formulae written using writeFormula to a Workbook object will not get picked up by read.xlsx().
This is because only the formula is written and left to Excel to evaluate the formula when the file is opened in Excel.
}
\examples{

## See formatting vignette for further examples.

## Options for default styling (These are the defaults)
options("openxlsx.borderColour" = "black")
options("openxlsx.borderStyle" = "thin")
options("openxlsx.dateFormat" = "mm/dd/yyyy")
options("openxlsx.datetimeFormat" = "yyyy-mm-dd hh:mm:ss")
options("openxlsx.numFmt" = NULL)

## Change the default border colour to #4F81BD
options("openxlsx.borderColour" = "#4F81BD")


#####################################################################################
## Create Workbook object and add worksheets
wb <- createWorkbook()

## Add worksheets
addWorksheet(wb, "Cars")
addWorksheet(wb, "Formula")


x <- mtcars[1:6, ]
writeData(wb, "Cars", x, startCol = 2, startRow = 3, rowNames = TRUE)

#####################################################################################
## Bordering

writeData(wb, "Cars", x,
  rowNames = TRUE, startCol = "O", startRow = 3,
  borders = "surrounding", borderColour = "black"
) ## black border

writeData(wb, "Cars", x,
  rowNames = TRUE,
  startCol = 2, startRow = 12, borders = "columns"
)

writeData(wb, "Cars", x,
  rowNames = TRUE,
  startCol = "O", startRow = 12, borders = "rows"
)


#####################################################################################
## Header Styles

hs1 <- createStyle(
  fgFill = "#DCE6F1", halign = "CENTER", textDecoration = "italic",
  border = "Bottom"
)

writeData(wb, "Cars", x,
  colNames = TRUE, rowNames = TRUE, startCol = "B",
  startRow = 23, borders = "rows", headerStyle = hs1, borderStyle = "dashed"
)


hs2 <- createStyle(
  fontColour = "#ffffff", fgFill = "#4F80BD",
  halign = "center", valign = "center", textDecoration = "bold",
  border = "TopBottomLeftRight"
)

writeData(wb, "Cars", x,
  colNames = TRUE, rowNames = TRUE,
  startCol = "O", startRow = 23, borders = "columns", headerStyle = hs2
)




#####################################################################################
## Hyperlinks
## - vectors/columns with class 'hyperlink' are written as hyperlinks'

v <- rep("https://CRAN.R-project.org/", 4)
names(v) <- paste0("Hyperlink", 1:4) # Optional: names will be used as display text
class(v) <- "hyperlink"
writeData(wb, "Cars", x = v, xy = c("B", 32))


#####################################################################################
## Formulas
## - vectors/columns with class 'formula' are written as formulas'

df <- data.frame(
  x = 1:3, y = 1:3,
  z = paste0(paste0("A", 1:3 + 1L), paste0("B", 1:3 + 1L), sep = " + "),
  stringsAsFactors = FALSE
)

class(df$z) <- c(class(df$z), "formula")

writeData(wb, sheet = "Formula", x = df)


#####################################################################################
## Save workbook
## Open in excel without saving file: openXL(wb)
\dontrun{
saveWorkbook(wb, "writeDataExample.xlsx", overwrite = TRUE)
}
}
\seealso{
\code{\link[=writeDataTable]{writeDataTable()}}
}
\author{
Alexander Walker
}
