% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateSeroincidence.R
\name{estimateSeroincidence}
\alias{estimateSeroincidence}
\title{Estimate Seroincidence}
\usage{
estimateSeroincidence(data, antibodies, strata = "", params, censorLimits,
  par0, start = -6, numCores = 1L)
}
\arguments{
\item{data}{Data frame with cross-sectional serology data per antibody and age, and additional
columns to identify possible \code{strata}.}

\item{antibodies}{Character vector with one or more antibody names. Values must match \code{data}.}

\item{strata}{Character vector of strata. Values must match with \code{data}. Default = "".}

\item{params}{List of data frames of all longitudinal parameters. Each data frame contains
Monte Carlo samples for each antibody type.}

\item{censorLimits}{List of cutoffs for one or more named antibody types (corresponding to
\code{data}).}

\item{par0}{List of parameters for the (lognormal) distribution of antibody concentrations
for true seronegatives (i.e. those who never seroconverted), by named antibody type
(corresponding to \code{data}).}

\item{start}{A starting value for \code{log(lambda)}. Value of -6 corresponds roughly to 1 day
(log(1/365.25)), -4 corresponds roughly to 1 week (log(7 / 365.25)). Default = -6.}

\item{numCores}{Number of processor cores to use for calculations when computing by strata. If
set to more than 1 and package \pkg{parallel} is available, then the computations are
executed in parallel. Default = 1L.}
}
\value{
A set of lambda estimates for each strata.
}
\description{
Function to estimate seroincidences based on cross-section serology data and longitudinal
response model.
}
\examples{

\dontrun{
estimateSeroincidence(data = csData,
                      antibodies = c("IgG", "IgM", "IgA"),
                      strata = "",
                      params = campylobacterDelftParams4,
                      censorLimits = cutOffs,
                      par0 = baseLn,
                      start = -4)

estimateSeroincidence(data = csData,
                      antibodies = c("IgG", "IgM", "IgA"),
                      strata = "",
                      params = campylobacterDelftParams4,
                      censorLimits = cutOffs,
                      par0 = baseLn,
                      start = -4,
                      numCores = parallel::detectCores())
}

}
