// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2024 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from CardReaderManager.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.smartcard {
  public class CardReaderManager_1_0_5 : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("smartcard.CardReaderManager:1.0.5", null);

    public CardReaderManager_1_0_5(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public CardReaderManager_1_0_5(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new CardReaderManager_1_0_5 StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new CardReaderManager_1_0_5(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public class CardReaderSettings : ICloneable {
      public object Clone() {
        CardReaderSettings copy = new CardReaderSettings();
        copy.name = this.name;
        copy.description = this.description;
        copy.cardFormat = this.cardFormat;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["name"] = this.name;
        json["description"] = this.description;
        json["cardFormat"] = this.cardFormat;
        return json;
      }

      public static CardReaderSettings Decode(LightJson.JsonObject json, Agent agent) {
        CardReaderSettings inst = new CardReaderSettings();
        inst.name = (string)json["name"];
        inst.description = (string)json["description"];
        inst.cardFormat = (string)json["cardFormat"];
        return inst;
      }

      public string name = "";
      public string description = "";
      public string cardFormat = "";
    }

    public class CardReaderEvent : Com.Raritan.Idl.idl.Event {
      static public readonly new TypeInfo typeInfo = new TypeInfo("smartcard.CardReaderManager_1_0_5.CardReaderEvent:1.0.0", Com.Raritan.Idl.idl.Event.typeInfo);

      public Com.Raritan.Idl.smartcard.CardReader_1_0_4 cardReader = null;
      public Com.Raritan.Idl.smartcard.CardReader_1_0_4.MetaData metaData = new Com.Raritan.Idl.smartcard.CardReader_1_0_4.MetaData();
    }

    public class CardReaderAttachedEvent : Com.Raritan.Idl.smartcard.CardReaderManager_1_0_5.CardReaderEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("smartcard.CardReaderManager_1_0_5.CardReaderAttachedEvent:1.0.0", Com.Raritan.Idl.smartcard.CardReaderManager_1_0_5.CardReaderEvent.typeInfo);

    }

    public class CardReaderDetachedEvent : Com.Raritan.Idl.smartcard.CardReaderManager_1_0_5.CardReaderEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("smartcard.CardReaderManager_1_0_5.CardReaderDetachedEvent:1.0.0", Com.Raritan.Idl.smartcard.CardReaderManager_1_0_5.CardReaderEvent.typeInfo);

    }

    public class CardReaderSettingsChangedEvent : Com.Raritan.Idl._event.UserEvent {
      static public readonly new TypeInfo typeInfo = new TypeInfo("smartcard.CardReaderManager_1_0_5.CardReaderSettingsChangedEvent:1.0.0", Com.Raritan.Idl._event.UserEvent.typeInfo);

      public Com.Raritan.Idl.smartcard.CardReader_1_0_4 cardReader = null;
      public Com.Raritan.Idl.smartcard.CardReaderManager_1_0_5.CardReaderSettings oldSettings = new Com.Raritan.Idl.smartcard.CardReaderManager_1_0_5.CardReaderSettings();
      public Com.Raritan.Idl.smartcard.CardReaderManager_1_0_5.CardReaderSettings newSettings = new Com.Raritan.Idl.smartcard.CardReaderManager_1_0_5.CardReaderSettings();
      public string position = "";
    }

    public class GetCardReadersResult {
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.smartcard.CardReader_1_0_4> _ret_;
    }

    public GetCardReadersResult getCardReaders() {
      JsonObject _parameters = null;
      var _result = RpcCall("getCardReaders", _parameters);
      var _ret = new GetCardReadersResult();
      _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.smartcard.CardReader_1_0_4>(_result["_ret_"].AsJsonArray.Select(
        _value => Com.Raritan.Idl.smartcard.CardReader_1_0_4.StaticCast(ObjectProxy.Decode(_value, agent))));
      return _ret;
    }

    public AsyncRequest getCardReaders(AsyncRpcResponse<GetCardReadersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getCardReaders(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getCardReaders(AsyncRpcResponse<GetCardReadersResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getCardReaders", _parameters,
        _result => {
          try {
            var _ret = new GetCardReadersResult();
            _ret._ret_ = new System.Collections.Generic.List<Com.Raritan.Idl.smartcard.CardReader_1_0_4>(_result["_ret_"].AsJsonArray.Select(
              _value => Com.Raritan.Idl.smartcard.CardReader_1_0_4.StaticCast(ObjectProxy.Decode(_value, agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetCardReaderByIdResult {
      public Com.Raritan.Idl.smartcard.CardReader_1_0_4 _ret_;
    }

    public GetCardReaderByIdResult getCardReaderById(string readerId) {
      var _parameters = new LightJson.JsonObject();
      _parameters["readerId"] = readerId;

      var _result = RpcCall("getCardReaderById", _parameters);
      var _ret = new GetCardReaderByIdResult();
      _ret._ret_ = Com.Raritan.Idl.smartcard.CardReader_1_0_4.StaticCast(ObjectProxy.Decode(_result["_ret_"], agent));
      return _ret;
    }

    public AsyncRequest getCardReaderById(string readerId, AsyncRpcResponse<GetCardReaderByIdResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getCardReaderById(readerId, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getCardReaderById(string readerId, AsyncRpcResponse<GetCardReaderByIdResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["readerId"] = readerId;
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("getCardReaderById", _parameters,
        _result => {
          try {
            var _ret = new GetCardReaderByIdResult();
            _ret._ret_ = Com.Raritan.Idl.smartcard.CardReader_1_0_4.StaticCast(ObjectProxy.Decode(_result["_ret_"], agent));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class SetCardReaderSettingsResult {
      public int _ret_;
    }

    public SetCardReaderSettingsResult setCardReaderSettings(string position, Com.Raritan.Idl.smartcard.CardReaderManager_1_0_5.CardReaderSettings setting) {
      var _parameters = new LightJson.JsonObject();
      _parameters["position"] = position;
      _parameters["setting"] = setting.Encode();

      var _result = RpcCall("setCardReaderSettings", _parameters);
      var _ret = new SetCardReaderSettingsResult();
      _ret._ret_ = (int)_result["_ret_"];
      return _ret;
    }

    public AsyncRequest setCardReaderSettings(string position, Com.Raritan.Idl.smartcard.CardReaderManager_1_0_5.CardReaderSettings setting, AsyncRpcResponse<SetCardReaderSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return setCardReaderSettings(position, setting, rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest setCardReaderSettings(string position, Com.Raritan.Idl.smartcard.CardReaderManager_1_0_5.CardReaderSettings setting, AsyncRpcResponse<SetCardReaderSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      var _parameters = new LightJson.JsonObject();
      try {
        _parameters["position"] = position;
        _parameters["setting"] = setting.Encode();
      } catch (Exception e) {
        if (fail != null) fail(e);
      }

      return RpcCall("setCardReaderSettings", _parameters,
        _result => {
          try {
            var _ret = new SetCardReaderSettingsResult();
            _ret._ret_ = (int)_result["_ret_"];
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetAllCardReaderSettingsResult {
      public System.Collections.Generic.IDictionary<string, Com.Raritan.Idl.smartcard.CardReaderManager_1_0_5.CardReaderSettings> _ret_;
    }

    public GetAllCardReaderSettingsResult getAllCardReaderSettings() {
      JsonObject _parameters = null;
      var _result = RpcCall("getAllCardReaderSettings", _parameters);
      var _ret = new GetAllCardReaderSettingsResult();
      _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
        _value => new System.Collections.Generic.KeyValuePair<string, Com.Raritan.Idl.smartcard.CardReaderManager_1_0_5.CardReaderSettings>(_value["key"], Com.Raritan.Idl.smartcard.CardReaderManager_1_0_5.CardReaderSettings.Decode(_value["value"], agent))));
      return _ret;
    }

    public AsyncRequest getAllCardReaderSettings(AsyncRpcResponse<GetAllCardReaderSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getAllCardReaderSettings(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getAllCardReaderSettings(AsyncRpcResponse<GetAllCardReaderSettingsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getAllCardReaderSettings", _parameters,
        _result => {
          try {
            var _ret = new GetAllCardReaderSettingsResult();
            _ret._ret_ = DictionaryHelper.Create(_result["_ret_"].AsJsonArray.Select(
              _value => new System.Collections.Generic.KeyValuePair<string, Com.Raritan.Idl.smartcard.CardReaderManager_1_0_5.CardReaderSettings>(_value["key"], Com.Raritan.Idl.smartcard.CardReaderManager_1_0_5.CardReaderSettings.Decode(_value["value"], agent))));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetSupportedCardFormatsResult {
      public System.Collections.Generic.IEnumerable<string> _ret_;
    }

    public GetSupportedCardFormatsResult getSupportedCardFormats() {
      JsonObject _parameters = null;
      var _result = RpcCall("getSupportedCardFormats", _parameters);
      var _ret = new GetSupportedCardFormatsResult();
      _ret._ret_ = new System.Collections.Generic.List<string>(_result["_ret_"].AsJsonArray.Select(
        _value => (string)_value));
      return _ret;
    }

    public AsyncRequest getSupportedCardFormats(AsyncRpcResponse<GetSupportedCardFormatsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getSupportedCardFormats(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getSupportedCardFormats(AsyncRpcResponse<GetSupportedCardFormatsResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getSupportedCardFormats", _parameters,
        _result => {
          try {
            var _ret = new GetSupportedCardFormatsResult();
            _ret._ret_ = new System.Collections.Generic.List<string>(_result["_ret_"].AsJsonArray.Select(
              _value => (string)_value));
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
