#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
TMPDIR=${TMPDIR-"/tmp"}
SBINDIR=${SBINDIR-"../../nfem/sbin"}
BINDIR=${BINDIR-"../../nfem/bin"}
SRCDIR=${SRCDIR-"../../../rheolef/doc/usrman"}
SRCGEO=${SRCGEO-"../../../rheolef/nfem/data"}
tmp="$TMPDIR/tmp"

RHEOLEF_BASIS_PATH=${RHEOLEF_BASIS_PATH-"../../nfem/basis"}
RHEOLEF_NUMBERING_PATH=${RHEOLEF_NUMBERING_PATH-"../../nfem/basis"}
RHEOLEF_FORM_ELEMENT_PATH=${RHEOLEF_FORM_ELEMENT_PATH-"../../nfem/form_element"}
export RHEOLEF_BASIS_PATH
export RHEOLEF_NUMBERING_PATH
export RHEOLEF_FORM_ELEMENT_PATH

status=0

# --------------------------------------------------------------------
# do meshes
# --------------------------------------------------------------------
command="${SBINDIR}/mkgeo_grid_2d 10 10 > square.geo"
echo "      $command"
eval $command 2>/dev/null
if test $? -ne 0; then echo "        => *NO*"; exit 1; fi

command="${SBINDIR}/mkgeo_grid_2d 10 10 -rz > square-rz.geo"
echo "      $command"
eval $command 2>/dev/null
if test $? -ne 0; then echo "        => *NO*"; exit 1; fi

command="${SBINDIR}/mkgeo_grid_3d 3 3 3 | ${BINDIR}/geo -upgrade -geo - > cube.geo"
echo "      $command"
eval $command 2>/dev/null
if test $? -ne 0; then echo "        => *NO*"; exit 1; fi

# --------------------------------------------------------------------
# plane and axisymetric stokes problem
# --------------------------------------------------------------------

for syscoord in cartesian rz; do
  case $syscoord in
     cartesian) geo=square;;
     rz)        geo=square-rz;;
  esac
  command="./stokes-poiseuille $geo"
  echo "      $command"
  eval $command >/dev/null 2>/dev/null
  if test $? -ne 0; then status=1; echo "        => *NO*"; fi

  command="./stokes-poiseuille-bubble $geo"
  echo "      $command"
  (eval $command >/dev/null) 2>&1 | grep "^error" | \
	diff ${SRCDIR}/stokes-poiseuille-bubble-$syscoord.err.valid - >/dev/null
  if test $? -ne 0; then status=1; echo "        => *NO*"; fi
done

# --------------------------------------------------------------------
# run tests on couette flow (stokes)
# --------------------------------------------------------------------

command="./stokes-couette $SRCGEO/couette-50"
echo "      $command"
(eval $command > /dev/null) 2>&1 | grep "^error_" | diff $SRCDIR/couette-50.err.valid -  >/dev/null
if test $? -ne 0; then status=1; echo "        => *NO*"; fi

command="./stokes-couette-bubble $SRCGEO/couette-50"
echo "      $command"
(eval $command > /dev/null) 2>&1 | grep "^error_" | diff $SRCDIR/couette-bubble-50.err.valid -  >/dev/null
if test $? -ne 0; then status=1; echo "        => *NO*"; fi

# --------------------------------------------------------------------
# run tests on cavity stokes problems
# --------------------------------------------------------------------

for mesh in square cube; do
  command="./stokes-cavity $mesh | ./stokes-cavity-tst"
  echo "      $command"
  eval $command 2>/dev/null
  if test $? -ne 0; then status=1; echo "        => *NO*"; fi
done

# --------------------------------------------------------------------
# run tests on abrupt contraction P1b-P1 stokes
# --------------------------------------------------------------------

command="./contraction-bubble ${SRCGEO}/contraction | ${BINDIR}/mfield -I${SRCGEO} -round 1e-4 -ndigit 4 -u -"
echo "      $command"
eval $command > $tmp.mfield  2>/dev/null
if test $? -ne 0; then status=1; echo "        => *NO*"; fi
gzip -d < ${SRCDIR}/contraction-bubble.mfield.valid.gz | diff - $tmp.mfield >/dev/null
if test $? -ne 0; then status=1; echo "        => *NO*"; fi

# --------------------------------------------------------------------
# run tests on embankment incompressible elasticity
# --------------------------------------------------------------------

for mesh in square cube; do
  command="./incompressible-elasticity $mesh 0 | ./incompressible-elasticity-tst"
  echo "      $command"
  eval $command 2>/dev/null
  if test $? -ne 0; then status=1; echo "        => *NO*"; fi
done

# --------------------------------------------------------------------
# run tests on embankment elasticity problems
# --------------------------------------------------------------------

command="./embankment square P1 | ${BINDIR}/mfield -round -ndigit 5 -u -"
echo "      $command"
eval $command > $tmp.mfield 2>/dev/null
gzip -d < ${SRCDIR}/embankment-square-p1.mfield.valid.gz | diff - $tmp.mfield >/dev/null
if test $? -ne 0; then status=1; echo "        => *NO*"; fi

command="./embankment square P2 | ${BINDIR}/mfield -round -ndigit 5 -u -"
echo "      $command"
eval $command > $tmp.mfield 2>/dev/null
gzip -d < ${SRCDIR}/embankment-square-p2.mfield.valid.gz | diff - $tmp.mfield >/dev/null
if test $? -ne 0; then status=1; echo "        => *NO*"; fi

command="./embankment cube P1 | ${BINDIR}/mfield -round -ndigit 5 -u -"
echo "      $command"
eval $command > $tmp.mfield 2>/dev/null
gzip -d < ${SRCDIR}/embankment-cube-p1.mfield.valid.gz | diff - $tmp.mfield >/dev/null
if test $? -ne 0; then status=1; echo "        => *NO*"; fi

command="./embankment cube P2 | ${BINDIR}/mfield -round -ndigit 5 -u -"
echo "      $command"
eval $command > $tmp.mfield 2>/dev/null
gzip -d < ${SRCDIR}/embankment-cube-p2.mfield.valid.gz | diff - $tmp.mfield >/dev/null
if test $? -ne 0; then status=1; echo "        => *NO*"; fi

# --------------------------------------------------------------------
# clean
# --------------------------------------------------------------------
command="/bin/rm -f line.geo square.geo square-rz.geo cube.geo $tmp.mfield"
echo "      $command"
eval $command

exit $status

