///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/form_element.h"

namespace rheolef {
using namespace std;

// calcul P = I - nxn
void
map_projector (
  const tensor& DF,
  size_t d,
  size_t map_d,
  tensor& P)
{
  point n;
  switch (map_d) {
    case 1: {
      point t = DF.col(0);
      check_macro (d == map_d+1, "unexpected dimension map_d="<<map_d<<" and d="<<d);
      n = point(t[1],-t[0]);
      break;
    }
    case 2: {
      point t0 = DF.col(0);
      point t1 = DF.col(1);
      n = vect(t0,t1);
      break;
    }
    default:
      error_macro ("unexpected dimension "<<map_d);
  }
  n = n/norm(n);
  for (size_t l = 0; l < d; l++) {
    for (size_t m = 0; m < d; m++) {
      P(l,m) = - n[l]*n[m];
    }
    P(l,l) += 1;
  }
}

} // namespace rheolef
