#!/bin/sh
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# -------------------------------------------------------------------------
#
# work around buggy texexpand / latex2html
# that do not recognize TEXINPUTS env variable
#
# usage:
#  texexpand.sh PERL TEXEXPAND {args}*
#
PERL=$1
shift
TEXEXPAND=$1
shift
shift

echo
echo "TEXEXPAND = " $TEXEXPAND
echo "PERL = " $PERL
echo "ARGS = " $*
echo

args=""
EXTRA_TEXINPUTS=""
while test $# -ne 0; do
  case $1 in
    -texinputs)
	 if test x"${EXTRA_TEXINPUTS}" = x""; then
           EXTRA_TEXINPUTS=$2
         else
           EXTRA_TEXINPUTS="${EXTRA_TEXINPUTS}:$2"
	 fi
         shift
         ;;
    *)   args="${args} $1"
	 ;;
  esac
  shift
done
if test x"${TEXINPUTS}" = x""; then
  TEXINPUTS=${EXTRA_TEXINPUTS}
else
  if test x"${EXTRA_TEXINPUTS}" != x""; then
     TEXINPUTS="${EXTRA_TEXINPUTS}:${TEXINPUTS}"
  fi
fi

export TEXINPUTS

echo "running: $PERL $TEXEXPAND -texinputs ${TEXINPUTS} ${args}"

$PERL $TEXEXPAND -texinputs ${TEXINPUTS} ${args}

