// file automatically generated by: ../../../rheolef/nfem/pbasis/make_numbering_list_cxx.sh
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
#include "rheolef/numbering.h"
#include "bubble_numbering.h"
#include "P1qd_numbering.h"
#include "Pk_numbering.h"
#include "Pkd_numbering.h"
#include "Pk_numbering.h"
#include "Pkd_numbering.h"
namespace rheolef {
using namespace std;

template <class T, class M>
numbering_rep<T,M>* 
numbering_rep<T,M>::make_ptr (string name) 
{
  // TODO: use gperf instead of a long if-else test suite
  if (name == "") return 0;
  if (name == "bubble") return new_macro((numbering_bubble<T,M>));
  if (name == "P1qd") return new_macro((numbering_P1qd<T,M>));
  if (name == "P0" || (name[0] == 'P' && name[name.size()-1] == 'd')) return new_macro((numbering_Pkd<T,M>)(name));
  if (name[0] == 'P') return new_macro((numbering_Pk<T,M>)(name));
  if (name[0] == 'R') return new_macro((numbering_Pk<T,M>)(name));
  error_macro ("undefined numbering `" << name << "'");
  return 0;
}
// ----------------------------------------------------------------------------
// instanciation in library
// ----------------------------------------------------------------------------

template numbering_rep<Float,sequential>* numbering_rep<Float,sequential>::make_ptr (string name);

#ifdef _RHEOLEF_HAVE_MPI
template numbering_rep<Float,distributed>* numbering_rep<Float,distributed>::make_ptr (string name);
#endif // _RHEOLEF_HAVE_MPI

} // namespace rheolef
