#include "rheolef.h"
#include "rheolef/pretty_name.h"
using namespace std;
using namespace rheolef;
Float phi (const point& x) { return norm(x) - 1; }
int main (int argc, char**argv) {
  environment rheolef(argc, argv);
  Float tol = (argc > 1) ? atof(argv[1]) : 1e-10;
  field phi_h;
  din >> catchmark("phi") >> phi_h;
  const space& Xh     = phi_h.get_geo();
  band gh (phi_h);
  space Bh (gh.band(), "P1");
  Bh.block ("isolated");
  Bh.unblock ("zero");
  field phi_h_band (Bh);
  din >> catchmark("phi_band") >> phi_h_band;
  field eh = phi_h [gh.band()] - phi_h_band;
  Float err = eh.max_abs(); 
  derr << "err = " << err << endl;
  return (err < tol) ? 0 : 1;
}
