% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transaction.R
\name{transactions}
\alias{transactions}
\alias{dbCommit,MySQLConnection-method}
\alias{dbBegin,MySQLConnection-method}
\alias{dbRollback,MySQLConnection-method}
\title{DBMS Transaction Management}
\usage{
\S4method{dbCommit}{MySQLConnection}(conn, ...)

\S4method{dbBegin}{MySQLConnection}(conn, ...)

\S4method{dbRollback}{MySQLConnection}(conn, ...)
}
\arguments{
\item{conn}{a \code{MySQLConnection} object, as produced by
\code{\link{dbConnect}}.}

\item{...}{Unused.}
}
\description{
Commits or roll backs the current transaction in an MySQL connection.
Note that in MySQL DDL statements (e.g. \code{CREATE TABLE}) can not
be rolled back.
}
\examples{
if (mysqlHasDefault()) {
con <- dbConnect(RMySQL::MySQL(), dbname = "test")
df <- data.frame(id = 1:5)

dbWriteTable(con, "df", df)
dbBegin(con)
dbGetQuery(con, "UPDATE df SET id = id * 10")
dbGetQuery(con, "SELECT id FROM df")
dbRollback(con)

dbGetQuery(con, "SELECT id FROM df")

dbRemoveTable(con, "df")
dbDisconnect(con)
}
}
