### New features

* [#9396](https://github.com/rubocop/rubocop/pull/9396): Add new `Style/IfWithBooleanLiteralBranches` cop. ([@koic][])
* [#9402](https://github.com/rubocop/rubocop/pull/9402): Add new `Lint/TripleQuotes` cop. ([@dvandersluis][])
* [#7827](https://github.com/rubocop/rubocop/pull/7827): Add pre-commit hook. ([@jdufresne][], [@adithyabsk][])
* [#7452](https://github.com/rubocop/rubocop/issues/7452): Support `IgnoredMethods` option for `Style/FormatStringToken`. ([@koic][])
* [#9340](https://github.com/rubocop/rubocop/pull/9340): Added `info` Severity level to allow offenses to be listed but not return a non-zero error code. ([@dvandersluis][])
* [#9353](https://github.com/rubocop/rubocop/issues/9353): Add new `Lint/SymbolConversion` cop. ([@dvandersluis][])
* [#9363](https://github.com/rubocop/rubocop/pull/9363): Add new cop `Lint/OrAssignmentToConstant`. ([@uplus][])
* [#9326](https://github.com/rubocop/rubocop/pull/9326): Add new `Lint/NumberedParameterAssignment` cop. ([@koic][])

### Bug fixes

* [#9366](https://github.com/rubocop/rubocop/issues/9366): Fix an incorrect auto-correct for `Style/SoleNestedConditional` when using method arguments without parentheses for outer condition. ([@koic][])
* [#9372](https://github.com/rubocop/rubocop/issues/9372): Fix an error for `Style/IfInsideElse` when nested `if` branch code is empty. ([@koic][])
* [#9374](https://github.com/rubocop/rubocop/issues/9374): Fix autocorrection for `Layout/LineLength` when the first argument to a send node is a overly long hash pair. ([@dvandersluis][])
* [#9387](https://github.com/rubocop/rubocop/issues/9387): Fix incorrect auto-correct for `Style/NilComparison` when using `!x.nil?` and `EnforcedStyle: comparison`. ([@koic][])
* [#9411](https://github.com/rubocop/rubocop/pull/9411): Fix false negatives for `Style/EvalWithLocation` for `Kernel.eval` and when given improper arguments. ([@dvandersluis][])
* [#7766](https://github.com/rubocop/rubocop/issues/7766): Fix `Naming/RescuedExceptionsVariableName` autocorrection when the rescue body returns the exception variable. ([@asterite][])
* [#7766](https://github.com/rubocop/rubocop/issues/7766): Fix `Naming/RescuedExceptionsVariableName` autocorrection to not change variables if the exception variable has been reassigned. ([@dvandersluis][])
* [#9389](https://github.com/rubocop/rubocop/pull/9389): Fix an infinite loop error for `IncludeSemanticChanges: false` of `Style/NonNilCheck` with `EnforcedStyle: comparison` of `Style/NilComparison`. ([@koic][])
* [#9384](https://github.com/rubocop/rubocop/pull/9384): Fix a suggestion message when not auto-correctable. ([@koic][])
* [#9424](https://github.com/rubocop/rubocop/pull/9424): Fix an incorrect auto-correct for `Style/ClassMethodsDefinitions` when defining class methods with `class << self` and there is no blank line between method definition and attribute accessor. ([@koic][])
* [#9370](https://github.com/rubocop/rubocop/issues/9370): Fix an incorrect auto-correct for `Style/SoleNestedConditional` when using nested `unless` modifier multiple conditional. ([@koic][])
* [#9406](https://github.com/rubocop/rubocop/pull/9406): Fix rubocop_todo link injection when YAML doc start sigil exists. ([@dduugg][])
* [#9229](https://github.com/rubocop/rubocop/pull/9229): Fix errors being reported with `rubocop -V` with an invalid config. ([@dvandersluis][])
* [#9425](https://github.com/rubocop/rubocop/issues/9425): Fix error in `Layout/ClassStructure` when initializer comes after private attribute macro. ([@tejasbubane][])

### Changes

* [#9415](https://github.com/rubocop/rubocop/issues/9415): Change `Layout/ClassStructure` to detect inline modifiers. ([@AndreiEres][])
* [#9380](https://github.com/rubocop/rubocop/issues/9380): Mark `Style/FloatDivision` as unsafe. ([@koic][])
* [#9345](https://github.com/rubocop/rubocop/issues/9345): Make `Style/AsciiComments` allow copyright notice by default. ([@koic][])
* [#9399](https://github.com/rubocop/rubocop/issues/9399): Added `AllowedCops` configuration to `Style/DisableCopsWithinSourceCodeDirective`. ([@dvandersluis][])
* [#9327](https://github.com/rubocop/rubocop/issues/9327): Change `Layout/EmptyLineAfterMagicComment` to accept top-level `shareable_constant_values` directive. ([@tejasbubane][])
* [#7902](https://github.com/rubocop/rubocop/issues/7902): Change `Lint/NumberConversion` to detect symbol form of conversion methods. ([@tejasbubane][])

[@koic]: https://github.com/koic
[@dvandersluis]: https://github.com/dvandersluis
[@jdufresne]: https://github.com/jdufresne
[@adithyabsk]: https://github.com/adithyabsk
[@uplus]: https://github.com/uplus
[@asterite]: https://github.com/asterite
[@dduugg]: https://github.com/dduugg
[@tejasbubane]: https://github.com/tejasbubane
[@AndreiEres]: https://github.com/AndreiEres
