# Generating error values

cargo-mutants can be configured to generate mutants that return an error value from functions that return a Result.

This will flag cases where no test fails if the function returns an error: that might happen if there are _only_ tests for the error cases and not for the Ok case.

Since crates can choose to use any type for their error values,
cargo-mutants must be told how to construct an appropriate error.

The `--error` command line option and the `error_value` configuration option specify an error value to use.

These options can be repeated or combined, which might be useful
if there are multiple error types in the crate. On any one mutation site, probably only one of the error values will be viable, and cargo-mutants will discover that and use it.

The error value can be any Rust expression that evaluates to a value of the error type. It should not include the `Err` wrapper, because cargo-mutants will add that.

For example, if your crate uses `anyhow::Error` as its error type, you might use `--error '::anyhow::anyhow!("error")'`.

If you have your own error type, you might use `--error 'crate::MyError::Generic'`.

Since the correct error type is a property of the source tree, the configuration should typically go into `.cargo/mutants.toml` rather than being specified on the command line:

```toml
error_values = ["::anyhow::anyhow!(\"mutated\")"]
```

To see only the mutants generated by this configuration, you
can use a command like this:

```sh
cargo r mutants -F anyhow -vV -j4
```
