/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file IfaceMsgHandler.h
    \author Romain BONDUE
    \date 09/06/06 */
#ifndef __IFACEMSGHANDLER_H__
#define __IFACEMSGHANDLER_H__

#include <string>
#include <stdexcept> // std::bad_alloc

#include "IMsgHandler.h"
#include "NetTools.h"
#include "Msg.h"
#include "Exceptions.h"



namespace nsRoot
{
    class CIfaceMsgHandler : public IMsgHandler
    {
      public :
        CMsg operator () (const CMsg&) throw (nsErrors::CException,
                                              std::bad_alloc);


      private :
        nsNet::CInterface m_Iface;

    }; // CIfaceMsgHandler

} // namespace nsRoot

#endif // __IFACEMSGHANDLER_H__
