/*  Copyright (c) 2005 Romain BONDUE
    This file is part of RutilT.

    RutilT is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    RutilT is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with RutilT; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
/** \file IfaceRoot.cxx
    \author Romain BONDUE
    \date 09/06/2006 */
#include "IfaceRoot.h"
#include "IfaceProtocolCodes.h"
#include "Msg.h"
#include "ErrorsCode.h"



nsNet::CInterfaceRoot::CInterfaceRoot (const CInterface& Iface)
                                                throw (nsErrors::CSystemExc)
    : CInterface (Iface), m_Su (IfaceHandler)
{
    SuDo (Iface.GetName(), DeviceNameC);

} // CInterfaceRoot()


void nsNet::CInterfaceRoot::SetIP (const CIPAddress& Addr)
                                                throw (nsErrors::CSystemExc)
{
    // TODO

} // SetIP()


void nsNet::CInterfaceRoot::SetIPFromDHCP (const std::string& Data)
                                                throw (nsErrors::CException)
{
    SuDo (Data, DhcpC);
 
} // SetIPFromDHCP()


void nsNet::CInterfaceRoot::Up () throw (nsErrors::CSystemExc)
{
    SuDo ("", UpC);

} // Up()


void nsNet::CInterfaceRoot::Down () throw (nsErrors::CSystemExc)
{
    SuDo ("", DownC);

} // Down()


void nsNet::CInterfaceRoot::SuDo (const std::string& Text, int Code)
                                                throw (nsErrors::CSystemExc)
{
    try
    {
        const nsRoot::CMsg ReturnedMsg (m_Su.Do (nsRoot::CMsg (Text, Code)));
        if (ReturnedMsg.GetCode())
            throw nsErrors::CSystemExc (ReturnedMsg.GetText(),
                                        ReturnedMsg.GetCode());
    }
    catch (const nsErrors::CException& Exc)
    {
        throw nsErrors::CSystemExc (Exc.GetMsg(), Exc.GetCode());
    }
    catch (const std::bad_alloc& Exc)
    {
        throw nsErrors::CSystemExc (Exc.what(), nsErrors::OutOfMemory);
    }

} // SuDo()
