#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
This module contains tools for consistent naming of classes.
"""

# Copyright (C) 2008-2009 Martin Sandve Alnes and Simula Resarch Laboratory
#
# This file is part of SyFi.
#
# SyFi is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# SyFi is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SyFi. If not, see <http://www.gnu.org/licenses/>.
#
# First added:  2008-08-12
# Last changed: 2009-04-23

import re
import hashlib

def short_name(prefix, name, max_name_length = 60):
    if len(name) > max_name_length:
        name = hashlib.md5(name).hexdigest().lower()
    return prefix + name

def base_element_classname(element):
    #return "%s_%s_%d" % (element.family, element.cell, element.degree)
    s = repr(element).strip()
    s = re.sub("[^\w]", "_", s)
    s = re.sub("_+", "_", s)
    s = s.strip("_")
    return s

def finite_element_classname(element):
    return short_name("fe_", base_element_classname(element))

def dof_map_classname(element):
    return short_name("dm_", base_element_classname(element))

def integral_classname(integral, form_name):
    m = integral.measure()
    prefix = "%s_integral_%s" % (m.domain_type(), m.domain_id())
    return short_name(prefix, form_name)

def form_classname(form, options):
    if options.code.form.name:
        form_name = options.code.form.name
    else:
        checksum = hashlib.md5(repr(form) + repr(options))
        form_name = checksum.hexdigest().lower()
    
    return short_name("form_", form_name)
